// Pure sine tone 440Hz
// Pure sine tone 180Hz
// Pure sine tone 1000Hz

// Rich sine tone 440Hz

// White noise
// String sound
// Vocal sound

Server.default = s = Server.internal.boot;
s.scope;


// generate pure sine tones
(

var sd, note, score, run, clar, noise;

score = CtkScore.new;

sd = CtkSynthDef(\simpleSine, {arg freq, dur, ampScale;
	var osc, env;
	env = EnvGen.kr(Env([-90, 0, 0, -90], [0.01, 0.98, 0.01], \sin), timeScale: dur);
	osc = SinOsc.ar(freq, 0, env.dbamp * ampScale.dbamp);
	Out.ar(0, Pan2.ar(osc))
});

//noise = CtkSynthDef(\simpleSine, {arg dur;
//	var osc, env;
//	env = EnvGen.kr(Env([-90, 0, 0, -90], [0.01, 0.98, 0.01], \sin), timeScale: dur);
//	osc = WhiteNoise.ar(0.5);
//	Out.ar(0, Pan2.ar(osc))
//});
//	
	
clar = {arg freq, amp, duration, starttime; 
	var partialAmps, freqScale, durScale;
	partialAmps = [0, 0, 0, 0, 0, 0, 0, 0, 0, 0];
	freqScale = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10];
	partialAmps.size.do({arg i;
		var thisAmp, thisFreq;
		thisAmp = partialAmps[i] + amp; 
		thisFreq = freqScale[i] * freq;
		score.add(sd.note(starttime + 2, duration).freq_(thisFreq).dur_(duration).ampScale_(thisAmp));
	});
};

//score.add(noise.note(2, 5).dur_(5));

clar.value(440, -25, 5, 0);  

//score.add(sd.note(2, 5).freq_(180).dur_(5).ampScale_(-1).play);

score.write("~/Desktop/whitenoise.wav".standardizePath, options: 
	ServerOptions.new.numOutputBusChannels_(1))

)

